<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @subpackage	dftk-utilityfct
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * Display an array, for debugging purpose
 *
 * @access		public
 * @param		array				&$arr					Array to display
 */
function dftk_display_array(&$arr)
{
	if (!is_array($arr))
		return;

	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($arr as $key1 => $elem1)
	{
		echo '<tr>';
		echo '<td>'.$key1.'&nbsp;</td>';
		if (is_array($elem1))
			_dftk_display_array2($elem1);
		else
			echo '<td>'.$elem1.'&nbsp;</td>';
		echo '</tr>';
	}
	echo '</table>';
}

/**
 * Display a part of an array
 *
 * @access		private
 * @param		array				$arr2					Part of array to display
 * @see			display_array()
 */
function _dftk_display_array2($arr2)
{
	echo '<td>';
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($arr2 as $key => $elem)
	{
		echo '<tr>';
		echo '<td>'.$key.'&nbsp;</td>';
		if (is_array($elem))
			_dftk_display_array2($elem);
		else
		{
			if (is_bool($elem))
			{
				if ($elem)
					echo '<td>#true#</td>';
				else
					echo '<td>#false#</td>';
			}
			else
				echo '<td>'.htmlspecialchars($elem).'&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
	echo '</td>';
}

/**
 * Crypt for unix usage
 *
 * @access		public
 * @param		string				$passwd					Clear-text Password
 * @return		string
 */
function dftk_unix_crypt($passwd)
{
	$salt=substr(ereg_replace("[^a-zA-Z0-9./]", "", crypt(rand(10000000,99999999), rand(10,99))), 2, 2);
	return crypt($passwd, "$1$".$salt);
}

/**
 * Test if is an hexadecimal number
 *
 * @access		public
 * @param		string				$val					Value to test
 * @return		boolean
 */
function dftk_is_hexa($val)
{
	if (preg_match("/^[0-9a-f]*$/i", $val)>0)
		return true;
	else
		return false;
}

/**
 * Delete a specified value in an array
 *
 * Delete each occurence of a specified value in an array
 * and reindex it.
 *
 * @access		public
 * @param		array				$tab_orig				Array to process
 * @param		mixed				$value					Value to delete
 * @return		array				$tab					Array processed
 */
function dftk_array_del_value($tab_orig, $value)
{
	$tab = array();

	for ($i=0; $i<count($tab_orig); $i++)
		if ($tab_orig[$i] != $value)
			$tab[] = $tab_orig[$i];

	return $tab;
}

/**
 * Insert a value in a specified position in an array
 *
 * @access		public
 * @param		array				$tab_orig				Array to process
 * @param		integer				$n						Position where to insert the value
 * @param		mixed				$value					Value to insert
 * @return		array				$tab					Array processed
 */
function dftk_array_insert($tab_orig, $n, $value)
{
	if ($n <= 0)
		return array_merge(array($value), $tab_orig);
	elseif ($n >= count($tab_orig))
		return array_merge($tab_orig, array($value));
	else
		return array_merge(array_slice($tab_orig, 0, $n), array($value), array_slice($tab_orig, $n));
}

/**
 * Insert a value in a sorted array
 *
 * This function ensure the array will stay sorted after each insert.
 *
 * @access		public
 * @param		array				$tab_orig				Array to process
 * @param		mixed				$value					Value to insert
 * @param		string				$fct					Name of the sort function
 * @return		array				$tab					Array processed
 */
function dftk_array_sorted_insert($tab_orig, $value, $fct)
{
	$n = count($tab_orig);
	
	for ($i=0; $i<count($tab_orig); $i++)
		if ($fct($value, $tab_orig[$i]))
		{
			$n = $i;
			break;
		}
	
	return dftk_array_insert($tab_orig, $n, $value);
}

?>
